﻿//////////////////////////////////////////////
// RenderContextDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Texture ;
}

namespace nkWinUi
{
	class Window ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderContextDescriptor final
	{
		public :

			// Functions
			// Constructor, destructor
			RenderContextDescriptor () noexcept ;
			RenderContextDescriptor (nkWinUi::Window* window, bool vsync = false) noexcept ;
			RenderContextDescriptor (Texture* colorTarget) noexcept ;
			RenderContextDescriptor (Texture* colorTarget, Texture* depthTarget) noexcept ;
			RenderContextDescriptor (unsigned int width, unsigned int height, bool forOffscreen, bool vsync = false) noexcept ;

			// Getters
			unsigned int getWidth () const ;
			unsigned int getHeight () const ;
			nkWinUi::Window* getWindow () const ;
			Texture* getColorTarget () const ;
			Texture* getDepthTarget () const ;
			bool getOffscreenContext () const ;
			bool getVsync () const ;

		private :

			// Attributes
			// Size in pixels
			unsigned int _width ;
			unsigned int _height ;

			// Pointer over window (non offscreen) or texture (offscreen) if applicable
			union
			{
				nkWinUi::Window* _window ;
				Texture* _colorTarget ;
			} ;

			Texture* _depthTarget ;

			// If this is an offscreen context or not
			bool _offscreenContext ;
			// If it will use vsync or not (onscreen only)
			bool _vsync ;
	} ;
}